;*
;* JAVA VIRTUAL MACHINE EXCEPTION SUPPORT FOR 6502
;*
	.INCLUDE	"global.inc"
	.INCLUDE	"class.inc"
	.INCLUDE	"frame.inc"
	.IMPORT	PRBLNK,PRBYTE,COUT,CROUT,PRNTAX
	.IMPORT	PUTS,PUTSLN,PRSTR,PRHSTR,PRSTRLN,MEMSRC,MEMDST,MEMCPY,MEMCLR
	.IMPORT	HMEM_PTR,HSTRPL_ADD
	.IMPORT	CLASS_STRING,CLASS_METHODPTR,RESOLVE_CLASS
	.IMPORT	CLASS_MATCH_NAME,CLASS_MATCH_DESC,RESOLVE_METHOD,CLASS_METHODPTR
	.IMPORT	ASYNC_STATIC
	.IMPORT	CURRENT_THREAD
	.IMPORT	VM_RESTART
	.EXPORT	EXCEPT_INIT,THROW_SYSEXCEPTN,THROW_INTERNALERR,UNHANDLED_EXCEPTN,CURRENTEXCEPTN,THREAD_TRACE
	
	.SEGMENT "INIT"
EXCEPT_INIT:	LDA	#<SYSTHROWSTR
	LDX	#>SYSTHROWSTR
	JSR	HSTRPL_ADD
	STA	HSYSTHROWSTR
	STX	HSYSTHROWSTR+1
	LDA	#<SYSEXCEPTNNAMESTR
	LDX	#>SYSEXCEPTNNAMESTR
	JSR	HSTRPL_ADD
	STA	HSYSEXCEPTNNAMESTR
	STX	HSYSEXCEPTNNAMESTR+1
	LDA	#<SYSEXCEPTNDESCSTR
	LDX	#>SYSEXCEPTNDESCSTR
	JSR	HSTRPL_ADD
	STA	HSYSEXCEPTNDESCSTR
	STX	HSYSEXCEPTNDESCSTR+1
	LDA	#<THREAD_TRACE		; CREATE EXTERNAL LINKEAGE TO DUMPSTACK
	STA	LINK_DUMPSTACK
	LDA	#>THREAD_TRACE
	STA	LINK_DUMPSTACK+1
	RTS
SYSTHROWSTR:	.BYTE	22,"apple2/SystemException"	; SYSTEM EXCEPTION CLASS
SYSEXCEPTNNAMESTR: .BYTE	20,"throwSystemException"	; THROW SYSTEM EXCEPTION METHOD NAME
SYSEXCEPTNDESCSTR: .BYTE	4,"(I)V"		; THROW SYSTEM EXCEPTION METHOD DESCRIPTOR

	.CODE
UNHANDLED_EXCEPTN: PSTRLN	"UNHANDLED EXCEPTION: "
	TSX
	LDA	$0105,X
	AND	#$7F
	TAY
	JSR	CLASS_STRING
	JSR	PRHSTR
	JSR	CROUT
	RTS
THROW_SYSEXCEPTN: TAX			; SAVE INDEX AS METHOD PARAM
	LDA	#$00
	PHA
	PHA
	PHA
	TXA
	PHA
	LDA	HSYSTHROWSTR
	LDX	HSYSTHROWSTR+1
	JSR	RESOLVE_CLASS
	BCS	:+
	LDA	HSYSEXCEPTNNAMESTR
	LDX	HSYSEXCEPTNNAMESTR+1
	JSR	CLASS_MATCH_NAME	; SAVE MATCH NAME
	LDA	HSYSEXCEPTNDESCSTR
	LDX	HSYSEXCEPTNDESCSTR+1
	JSR	CLASS_MATCH_DESC	; SAVE MATCH TYPE
	JSR	RESOLVE_METHOD		; LOOK IT UP
	BCS	:+		; METHOD NOT FOUND - REAL BAD
	JSR	ASYNC_STATIC
	PLA
	STA	CURRENTEXCEPTN
	PLA
	STA	CURRENTEXCEPTN+1
	PLA
	STA	CURRENTEXCEPTN+2
	PLA
	STA	CURRENTEXCEPTN+3
	RTS
:	PERR	"SYS EXCEPTION METHOD NOT FOUND!"
THROW_INTERNALERR:
	JSR	THREAD_TRACE
.IFDEF	DEBUG
	BRK
.ENDIF
	LDA	#$FF
	TAX
	JMP	VM_RESTART
THREAD_TRACE:
.IFDEF	DEBUG
	TSX
	INX
	INX
	STX	DUMP_TOS
	JSR	CROUT
	PSTR	"CURRENT THREAD: "
	LDA	CURRENT_THREAD
	JSR	PRBYTE
	JSR	CROUT
	LDA	HEXECFRAME		; SET FRAME POINTER
	LDX	HEXECFRAME+1
	BNE	:+
	PSTRLN	"NO CURRENT FRAME"
	LDA	#$FF
	JMP	DUMPSTACK
:	JSR	PRNTMETHD
	LDA	EXECPC
	SEC
	SBC	EXECCODEPTR
	TAX
	INY
	LDA	EXECPC+1
	SBC	EXECCODEPTR+1
	JSR	PRNTAX
	JSR	CROUT
	LDY	#FRAMESP
	LDA	(EXECFRAMEPTR),Y
	PHA
	JSR	DUMPSTACK
	PLA
	STA	DUMP_TOS
FRAMETRACE:	LDY	#FRAMELINKPREV+1
	LDA	(EXECFRAMEPTR),Y
	BNE	:+
	JSR	CROUT
	RTS
:	DEY
	TAX
	LDA	(EXECFRAMEPTR),Y
	JSR	PRNTMETHD
	LDY	#FRAMEPC
	LDA	(EXECFRAMEPTR),Y
	INY
	TAX
	LDA	(EXECFRAMEPTR),Y
	JSR	PRNTAX
	JSR	CROUT
	LDY	#FRAMESP
	LDA	(EXECFRAMEPTR),Y
	PHA
	JSR	DUMPSTACK
	PLA
	STA	DUMP_TOS
	JMP	FRAMETRACE
DUMPSTACK:	PHA
	PSTRLN	"EVAL STACK:"
	PLA
	TAY
DUMPSTKLP:	CPY	DUMP_TOS
	BCS	:+
	RTS
:	BNE	:+
	RTS
:	DEY
	STY	TMP
	TYA
	JSR	PRBYTE
	LDA	#':'
	JSR	COUT
	LDY	TMP
	LDX	$0100,Y
	LDA	$0101,Y
	JSR	PRNTAX
	JSR	CROUT
	LDY	TMP
	DEY
	BNE	DUMPSTKLP
PRNTMETHD:	JSR	HMEM_PTR
	STA	EXECFRAMEPTR
	STX	EXECFRAMEPTR+1
	LDY	#FRAMEICLASS
	LDA	(EXECFRAMEPTR),Y
	PHA
	TAY
	JSR	CLASS_STRING
	JSR	PRHSTR
	LDA	#'.'
	JSR	COUT
	PLA
	STA	TMP
	LDY	#FRAMEMETHOD+1
	LDA	(EXECFRAMEPTR),Y
	DEY
	TAX
	LDA	(EXECFRAMEPTR),Y
	LDY	TMP
	JSR	CLASS_METHODPTR		; GET POINTER TO METHOD
	STA	METHODPTR
	STX	METHODPTR+1
	LDY	#METHODNAME+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	LDY	#METHODDESC+1
	LDA	(METHODPTR),Y
	DEY
	TAX
	LDA	(METHODPTR),Y
	JSR	PRHSTR
	LDA	#'#'
	JMP	COUT
.ELSE
	RTS
.ENDIF
	.DATA
DUMP_TOS:	.BYTE	0
HSYSTHROWSTR:	.WORD	$0000
HSYSEXCEPTNNAMESTR: .WORD	$0000
HSYSEXCEPTNDESCSTR: .WORD	$0000
CURRENTEXCEPTN:	.BYTE	0,0,0,0